# VHDLtoJSON.py
# By Marcelo Machado 60642 
# mj.machado@campus.fct.unl.pt

# Python script that converts a .txt file with VHDL code into a JSON file that can be used
# by the NOVA-HDL-Assist

# Instructions: (requires python 3)
# REQUIRES: Configuratio.txt and Select.json files - some options are still missing from "Select.json"
# run the following command in the terminal: python3 VHDLtoJSON.py <name of .txt file> <name of desired .json file to create>
# User will be then prompted to insert the module name that should be displayed in the NOVA-HDL-Assist
# Upon pressing ENTER, a .json file should be created.

import sys      # provides access to comand line arguments
import re       # to be able to use of regular expressions
import json     # to be able to write to .json files

# Detects if user input for file names includes the extension or not.
def configureFileName(argNumber, type):
    if(type in sys.argv[argNumber]):
        fileName = sys.argv[argNumber]
    else:
        fileName = sys.argv[argNumber] + type
    return fileName

# Removes repeated items from genericNames.
def trimList(rawList):
    trimmedList = []
    for elem in rawList:
        if(elem not in trimmedList):
            trimmedList.append(elem)
    return trimmedList

# Returns all valid configuration names from file "Configuration.txt" as a list.
def readConfigurationNameFile():
    configList = []
    configFile = open("Configuration.txt")
    for line in configFile:
        configList.append(line[0:-1])
    return configList

# Returns a python list from the list in file "Select.json" with possible dropdown menu names
# and fields for specific NOVA-HDL-Assist configurations.
def readConfigurationSelectFile():
    jsonFile = open("Select.json")

    text = jsonFile.read()
    selectList = json.loads(text)

    return selectList

# Returns a list with all valid configuration names to be added to the new .json file
# in the field "inputtext"
def getConfigurationNames(rawList, configList):
    newList = []
    for line in rawList:
        if line in configList:
            newList.append(line)
    return newList

# Returns a list with all valid configuration names to be added to the new .json file
# in the field "selects", that generates dropdown menus
def getConfigurationSelect(rawList, selectList):
    newList = []
    for line in rawList:
        for elem in selectList:
            if line == elem["name"]:
                newList.append(elem)
    return newList

def main():
    # load content of "Configuration.txt" and "Selection.json" into lists
    configList = readConfigurationNameFile()
    selectList = readConfigurationSelectFile()

    VHDLfileName = configureFileName(1, ".txt")
    JSONfileName = configureFileName(2, ".json")

    # open .txt file and create .json file
    VHDLfile = open(VHDLfileName)
    JSONfile = open(JSONfileName, "x")

    # sets variables that will be included in the json file
    moduleName = input("What should be the module name: ")
    moduleCode = VHDLfile.read()
    genericsAll = re.findall("<[0-9a-zA-Z_-]*?>", moduleCode)
    genericsTrim = trimList(genericsAll)
    genericNames = getConfigurationNames(genericsTrim, configList)
    selects = getConfigurationSelect(genericsTrim, selectList)

    # option to add autogenerate code from a file - UNTESTED
    op = input("Do you want to add any <AUTOGENERATE> code? ")
    autoGenCode = ""
    if (op.upper() == "Y" or op.upper() == "YES" or op.upper == "S" or op.upper == "SIM"):
        autoGenFileName = input("Place your <AUTOGENERATE> code in a .txt file and write the filename here (include the extension): ")
        autoGenFile = open(autoGenFileName)
        autoGenCode = autoGenFile.read()

    # json file contents
    fileContents = {
    "inputtext" : genericNames,
    "selects" : selects,
    "autogenerate" : autoGenCode,
    "moduleName" : moduleName,
    "moduleCode" : moduleCode
    }

    # write to json file
    dump = json.dumps(fileContents, indent=4)
    JSONfile.write(dump)
    print("Written to file " + JSONfileName)
    print("Paste the following line in nova-hdl-assist/modules/content_list_of_modules.json (mind the comma at the end)")
    print("  { \"name\" : \"" + moduleName + "\", \"url\" : \"https://raw.githubusercontent.com/nova-hdl-assist/modules/main/" + JSONfileName +"\"},")

    VHDLfile.close()
    JSONfile.close()

if __name__=="__main__":
    main()